<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">



	<!-- Item 5 templates -->

	<xsl:template name="Item5">
		<link href="style.css" rel="stylesheet" type="text/css" />
		<div id="maiItem5">
			<div class="contentwrapper">
				<div class="content">
					<h1>Item 5 Other Business</h1>
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
					<div class="tableRow noborder">
					<div class="tdStyle1 tdCrmCol1">
								Is the individual currently engaged in any other business either as a
								proprietor, partner, officer, director,
								<em>employee,</em>
								trustee, agent or otherwise?
					</div>
					
					<div class="tdStyle1 tdCrmCol2">						
						<xsl:choose>
									<xsl:when test="n2:isEngagedInOtherBusiness= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when test="n2:isEngagedInOtherBusiness = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								NO
					</div>
					</div>
					<div style="clear:both"></div>
					</div>					
					<xsl:if  test=" n2:isEngagedInOtherBusiness= 'Y' ">
						  <p>If &quot;Yes&quot;, please enter the following details for each other business below:</p>
							<xsl:for-each 	select="n2:otherBusinesses/n2:otherBusiness">
							
							<h2>Other Business</h2>
							<div class="mainDiv2" style="margin-left:0; margin-right:0;">
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">Start Date:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:startDate" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">Name of Business:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:name" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">Street Address 1:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of
										select="n2:addressInfo/ns1:street1" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">Street Address 2:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:addressInfo/ns1:street2" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">City:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:addressInfo/ns1:city" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">State/Country:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:addressInfo/ns1:stateOrCountry" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">Postal Code:</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:addressInfo/ns1:zipCode" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">
									Is this a
									<em>municipal advisor-related</em>
									business?
								</div>
								<div class="tdStyle1 tdCrmCol2"> 						
									<xsl:choose>
									<xsl:when
										test="n2:isRelatedToMunicipalAdvisor= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="n2:isRelatedToMunicipalAdvisor = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">
									Is this an
									<em>investment-related</em>
									business?
								</div>
								<div class="tdStyle1 tdCrmCol2"> 						
									<xsl:choose>
									<xsl:when
										test="n2:isRelatedToInvestment= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="n2:isRelatedToInvestment = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">
								Nature of Business:
								</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:natureOfBusiness" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">
								Position/Title/Relationship: 
								</div>
								<div class="tdStyle1 tdCrmCol2Textbox"> 						
									<xsl:value-of select="n2:positionDescription" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">
								Approximate No. of Hours/Month Devoted to This Business: 
								</div>
								<div class="tdStyle1 tdCrmCol2Textbox">						
									<xsl:value-of select="n2:approximateHoursOrMonths" />
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdCrmCol1">
								Description of Duties:
								</div>
								<div class="tdStyle1 tdCrmCol2Textbox">						
									<xsl:value-of select="n2:dutiesDescription" />
								</div>
							</div>
							<div style="clear:both"></div>
							</div>						
					</xsl:for-each>
				</xsl:if>
				</div>
			</div>
		</div>

	</xsl:template>

</xsl:stylesheet>